#!/usr/bin/env python3
# -*- coding: utf-8 -*-

import time
import lgpio

# ==================
CHIP = 4              #
BUZZER_GPIO = 25      # BCM25
DUTY = 0.5            # 50%
BASE_DELAY = 0.1
GAP = 0.02            # 

# =========  =========
tones = {
    'L1': 175, 'L2': 196, 'L3': 221, 'L4': 234, 'L5': 262, 'L6': 294, 'L7': 330,
    '1': 350,  '2': 393,  '3': 441,  '4': 495,  '5': 556,  '6': 624,  '7': 661,
    'H1': 700, 'H2': 786, 'H3': 882, 'H4': 935, 'H5': 965, 'H6': 996, 'H7': 1023,
    '0': 0
}

# ========= （Jingle Bells） =========
jingle_bells = ["5","H3","H2","H1","5","0","5","5",
                "5","H3","H2","H1","6","0","6","6",
                "6","H4","H3","H2","7","0","H5","H5","H4","H2","H3","0","5","5",
                "5","H3","H2","H1","5","0","5","5",
                "5","H3","H2","H1","6","0","6","6",
                "6","H4","H3","H2","H5","H5","H5","H6","H5","H4","H2","H1","0",
                "H3","H3","H3","H3","H3","H3","H3","H5","H1","H2","H3","0",
                "H4","H4","H4","H4","H3","H3","H3","H2","H2","H1","H2","H5",
                "H3","H3","H3","H3","H3","H3","H3","H5","H1","H2","H3","0",
                "H4","H4","H4","H4","H3","H3","H5","H5","H4","H2","H1","0",
                "5","H3","H2","H1","5","0","5","5",
                "5","H3","H2","H1","6","0","6","6",
                "6","H4","H3","H2","7","0","H5","H5","H4","H2","H3","0","5","5",
                "5","H3","H2","H1","5","0","5","5",
                "5","H3","H2","H1","6","0","6","6",
                "6","H4","H3","H2","H5","H5","H5","H6","H5","H4","H2","H1","0",
                "H3","H3","H3","H3","H3","H3","H3","H5","H1","H2","H3","0",
                "H4","H4","H4","H4","H3","H3","H3","H2","H2","H1","H2","H5",
                "H3","H3","H3","H3","H3","H3","H3","H5","H1","H2","H3","0",
                "H4","H4","H4","H4","H3","H3","H5","H5","H4","H2","H1","0",
                "H1","H5","H1"]

jingle_bells_delay = [2,2,2,2,4,2,1,1,
                      2,2,2,2,4,2,1,1,
                      2,2,2,2,4,4,2,2,2,2,4,2,1,1,
                      2,2,2,2,4,2,1,1,
                      2,2,2,2,4,2,1,1,
                      2,2,2,2,2,2,4,2,2,2,2,4,4,
                      2,2,4,2,2,4,2,2,2,1,4,4,
                      2,2,4,2,2,4,2,2,2,2,4,4,
                      2,2,4,2,2,4,2,2,2,1,4,4,
                      2,2,4,2,2,4,2,2,2,2,4,4,
                      2,2,2,2,4,2,1,1,
                      2,2,2,2,4,2,1,1,
                      2,2,2,2,4,4,2,2,2,2,4,2,1,1,
                      2,2,2,2,4,2,1,1,
                      2,2,2,2,4,2,1,1,
                      2,2,2,2,2,2,4,2,2,2,2,4,4,
                      2,2,4,2,2,4,2,2,2,1,4,4,
                      2,2,4,2,2,4,2,2,2,2,4,4,
                      2,2,4,2,2,4,2,2,2,1,4,4,
                      2,2,4,2,2,4,2,2,2,2,4,4,
                      4,4,4]

def busy_wait_until_ns(target_ns: int):
    
    while time.perf_counter_ns() < target_ns:
        pass

def soft_pwm_tone_busy(h, gpio: int, freq_hz: int, dur_s: float, duty: float = 0.5):
    
    if dur_s <= 0:
        return

    if freq_hz <= 0:
        lgpio.gpio_write(h, gpio, 0)
        time.sleep(dur_s)
        return

    period_ns = int(1_000_000_000 / freq_hz)
    high_ns = int(period_ns * duty)
    low_ns = period_ns - high_ns

    end_ns = time.perf_counter_ns() + int(dur_s * 1_000_000_000)

    next_ns = time.perf_counter_ns()
    while next_ns < end_ns:
        # HIGH
        lgpio.gpio_write(h, gpio, 1)
        next_ns += high_ns
        busy_wait_until_ns(min(next_ns, end_ns))

        # LOW
        lgpio.gpio_write(h, gpio, 0)
        next_ns += low_ns
        busy_wait_until_ns(min(next_ns, end_ns))

    lgpio.gpio_write(h, gpio, 0)

def main():

    h = lgpio.gpiochip_open(CHIP)
    try:
        lgpio.gpio_claim_output(h, BUZZER_GPIO, 0)
        lgpio.gpio_write(h, BUZZER_GPIO, 0)
        time.sleep(0.05)

        for tone, mult in zip(jingle_bells, jingle_bells_delay):
            freq = tones.get(tone, 0)
            dur = mult * BASE_DELAY

            soft_pwm_tone_busy(h, BUZZER_GPIO, freq, dur, DUTY)

            
            lgpio.gpio_write(h, BUZZER_GPIO, 0)
            time.sleep(GAP)

    finally:
        try:
            lgpio.gpio_write(h, BUZZER_GPIO, 0)
            lgpio.gpio_free(h, BUZZER_GPIO)
        except Exception:
            pass
        lgpio.gpiochip_close(h)

if __name__ == "__main__":
    main()
